<?php
	use gmt\view\Template;

	// O view do módulo sempre será o aruqivo html com o mesmo nome do módulo
	$view   = router(0);

	// Define o modulo de acordo com o view
	$modulo = $view;

	// Importa o aruqivo html do módulo
	$tpl = new Template('modulos/'.$view.'/view/'.$view.'.html');

	// Define o título do módulo
	$tpl->MODULO_TITULO = 'Módulo de exemplo';

	// Define a url base do módulo
	$tpl->MODULO_URL = $modulo;

	// Se a rota 1 for insert ou update, imprime o formulário no view
	if(router(1) == "insert" or router(1) == "update")
	{
		$tpl->ROUTER_IU = router(1);
		$tpl->ID        = (router(2) <> 0) ? router(2) : 0;

		$tpl->block("BLOCK_SHOW_FORM");
	}
	else // Caso contrario imprime a lista com os registros
	{

		if(ALL_SESSIONS["oh"]["tipo"] == "admin")
		{
			$tpl->SUPER = 'true';
			$getEmpresas = $gmCall->getAll($conn, "gm_empresas", array("*"), "", "ORDER BY nome ASC");

			foreach($getEmpresas as $empresa)
			{
				$tpl->LN_EMP_NOME = $empresa->nome. ' - ' .maskAll($empresa->cpf_cnpj, "##.###.###/####-##");
				$tpl->LN_EMP_ID   = $empresa->ID;
				$tpl->block("WHILE_EMPRESAS");
			}

			$tpl->block("BLOCK_SUPER");
		}
		else
		{
			$tpl->SUPER = 'false';			
		}

		$tpl->block("BLOCK_SHOW_LISTA");
	}

 	$tpl->show();